LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
ENTITY alarm_cntrl IS
  PORT( smoke, front_door, back_door, side_door, 
        alarm_disable, main_disable, 
        water_detect : IN std_logic;
        fire_alarm, burg_alarm,
        water_alarm : OUT std_logic);
END alarm_cntrl;

ARCHITECTURE synth OF alarm_cntrl IS
BEGIN
  PROCESS(smoke, front_door, back_door, side_door, alarm_disable, main_disable,
          water_detect)
  BEGIN
    IF ((smoke = '1') AND (main_disable = '0')) THEN 
      fire_alarm <= '1';
   ELSE
      fire_alarm <= '0';
    END IF;

    IF (((front_door = '1') OR (back_door = '1') OR (side_door = '1')) AND
         ((alarm_disable = '0') AND (main_disable = '0'))) THEN
      burg_alarm <= '1';
    ELSE
      burg_alarm <= '0';
    END IF;

    IF ((water_detect = '1') AND (main_disable = '0')) THEN
      water_alarm <= '1';
    ELSE
      water_alarm <= '0';
    END IF;
  END PROCESS;
END synth;

